USE  [V5_Registry]

/****************************************************************************
* POLYTRAUMA DATABASE CHANGES - Jan. 2014 (PII)
* Summary of updates:
*  - [TBI_POLYTRAUMA] - several fields added
*  - [STD_TBIINJURYLIST] - add entry of 'Physical Assault' to next to last entry
*  - [STD_POLYTRAUMA_ENTRY_TYPE] - new table
*  - [STD_POLYTRAUMA_SEVERITY_LEVEL_INDEX] - new table
*  - [STD_PERSON_LIVING_WITH] - new table
*  - [STD_POLYTRAUMA_EMPLOYMENT_STATUS] - new table
*  - [STD_TBIDSCHRGSTS] - set all old values as inactive and add new values.
*
****************************************************************************/

/************   Change #1   ************/
-- Add Physical Assault to the Injury List and update 'Other' to have the last sort value.
INSERT INTO [TBI].[STD_TBIINJURYLIST]([CODE], [NAME], [DESCRIPTION_TEXT], [SORT_ORDER], [INACTIVE_FLAG], [INACTIVE_DATE], [CREATEDBY], 
[UPDATEDBY], [CREATED], [UPDATED]) 
VALUES('Physical Assault', 'Physical Assault', 'Physical Assault', 18, 0, NULL, 'DNS   RYANK', 'DNS   RYANK', GETDATE(), GETDATE());

-- change sort order of 'other' so it's last
UPDATE [TBI].[STD_TBIINJURYLIST] SET [SORT_ORDER] = 19 WHERE ID = 18;

-- Add column to TBI_POLYTRAUMA for PHYSICAL_ASSAULT_INJRY_IND
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'TBI_POLYTRAUMA' AND COLUMN_NAME = 'PHYSICAL_ASSAULT_INJRY_IND')
ALTER TABLE [TBI].[TBI_POLYTRAUMA] ADD [PHYSICAL_ASSAULT_INJRY_IND] varchar(1) NULL;

/************ End Change #1 ************/


/************   Change #2   ************/
-- Alter TBI_POLYTRAUMA table to have JFK Coma Recovery Scale score column (JFK_COMA_RECOVERY - int, null)
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'TBI_POLYTRAUMA' AND COLUMN_NAME = 'JFK_COMA_RECOVERY')
ALTER TABLE [TBI].[TBI_POLYTRAUMA] ADD [JFK_COMA_RECOVERY] int NULL;
/************ End Change #2 ************/


/************   Change #3   ************/
-- CREATE [TBI].[STD_POLYTRAUMA_ENTRY_TYPE] table for storing types of Polytrauma entries (PRC and PTRP) and insert initial data.
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[TBI].[STD_POLYTRAUMA_ENTRY_TYPE]') AND type in (N'U'))
BEGIN
CREATE TABLE [TBI].[STD_POLYTRAUMA_ENTRY_TYPE](
	[ID] [int] IDENTITY(1,1) NOT NULL,
	[CODE] [varchar](50) NOT NULL,
	[NAME] [varchar](100) NOT NULL,
	[DESCRIPTION_TEXT] [varchar](500) NOT NULL,
	[SORT_ORDER] [int] NOT NULL,
	[INACTIVE_FLAG] [bit] NOT NULL,
	[INACTIVE_DATE] [datetime] NULL,
	[CREATEDBY] [varchar](30) NOT NULL,
	[CREATED] [datetime] NOT NULL,
	[UPDATEDBY] [varchar](30) NOT NULL,
	[UPDATED] [datetime] NOT NULL,
	[ROW_VERSION] [timestamp] NOT NULL,
 CONSTRAINT [PK_STD_POLYTRAUMA_ENTRY_TYPE] PRIMARY KEY CLUSTERED 
(
	[ID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]

-- INSERT INITIAL DATA (PRC / PTRP)
INSERT INTO [TBI].[STD_POLYTRAUMA_ENTRY_TYPE]([CODE], [NAME], [DESCRIPTION_TEXT], [SORT_ORDER], [INACTIVE_FLAG], [INACTIVE_DATE], [CREATEDBY], 
[CREATED], [UPDATEDBY], [UPDATED]) 
VALUES('PRC', 'PRC', 'Polytrauma Rehabilitation Center', 1, 0, NULL, 'DNS   RYANK', GETDATE(), 'DNS   RYANK', GETDATE());

INSERT INTO [TBI].[STD_POLYTRAUMA_ENTRY_TYPE]([CODE], [NAME], [DESCRIPTION_TEXT], [SORT_ORDER], [INACTIVE_FLAG], [INACTIVE_DATE], [CREATEDBY], 
[CREATED], [UPDATEDBY], [UPDATED]) 
VALUES('PTRP', 'PTRP', 'Polytrauma Transitional Rehabilitation Program', 2, 0, NULL, 'DNS   RYANK', GETDATE(), 'DNS   RYANK', GETDATE());

END
GO


-- ADD ENTRY_TYPE_ID to TBI.TBI_POLYTRAUMA
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'TBI_POLYTRAUMA' AND COLUMN_NAME = 'ENTRY_TYPE_ID')
BEGIN

ALTER TABLE TBI.TBI_POLYTRAUMA ADD ENTRY_TYPE_ID int NULL

ALTER TABLE TBI.TBI_POLYTRAUMA ADD CONSTRAINT
	FK_TBI_POLYTRAUMA_STD_POLYTRAUMA_ENTRY_TYPE FOREIGN KEY
	(
	ENTRY_TYPE_ID
	) REFERENCES TBI.STD_POLYTRAUMA_ENTRY_TYPE
	(
	ID
	) ON UPDATE  NO ACTION 
	 ON DELETE  NO ACTION 
	
END
GO

/************ End Change #3 ************/


/************   Change #4   ************/
-- Add IS_FOLLOW_UP field (if 1  followup, if 0 or null  admission)
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'TBI_POLYTRAUMA' AND COLUMN_NAME = 'IS_FOLLOW_UP')
ALTER TABLE TBI.TBI_POLYTRAUMA ADD IS_FOLLOW_UP bit NULL

/************ End Change #4 ************/


/************   Change #5   ************/
-- Add GENITO_URINARY_INJURIES field (bit) 1 = true ... 0 or NULL = false
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'TBI_POLYTRAUMA' AND COLUMN_NAME = 'GENITO_URINARY_INJURIES')
ALTER TABLE TBI.TBI_POLYTRAUMA ADD GENITO_URINARY_INJURIES bit NULL

/************ End Change #5 ************/


/************   Change #6   ************/
-- INSERT NEW VALUES INTO TBI.STD_TBIDISCHARGETO table for new desired values.  To keep legacy data intact, start sort order at 50 and in (GetRehabDischargeToList -> DropDownList.cs) filter where sort order >= 50

IF (SELECT MAX(ID) FROM TBI.STD_TBIDISCHARGETO) < 6
BEGIN

UPDATE TBI.STD_TBIDISCHARGETO SET [INACTIVE_FLAG] = 1, [INACTIVE_DATE] = GETDATE() WHERE ID < 6;

--Private
INSERT INTO TBI.STD_TBIDISCHARGETO([CODE], [NAME], [DESCRIPTION_TEXT], [SORT_ORDER], [INACTIVE_FLAG], [INACTIVE_DATE], [CREATED], [UPDATED], 
[CREATEDBY], [UPDATEDBY]) VALUES('Private', 'Private', 'Private', 1, 0, NULL, GETDATE(), GETDATE(), 'DNS   RYANK', 'DNS   RYANK');

--Nursing Home
INSERT INTO TBI.STD_TBIDISCHARGETO([CODE], [NAME], [DESCRIPTION_TEXT], [SORT_ORDER], [INACTIVE_FLAG], [INACTIVE_DATE], [CREATED], [UPDATED], 
[CREATEDBY], [UPDATEDBY]) VALUES('Nursing_Home', 'Nursing Home', 'Nursing Home', 2, 0, NULL, GETDATE(), GETDATE(), 'DNS   RYANK', 'DNS   RYANK');

--Adult Home
INSERT INTO TBI.STD_TBIDISCHARGETO([CODE], [NAME], [DESCRIPTION_TEXT], [SORT_ORDER], [INACTIVE_FLAG], [INACTIVE_DATE], [CREATED], [UPDATED], 
[CREATEDBY], [UPDATEDBY]) VALUES('Adult_Home', 'Adult Home', 'Adult Home', 3, 0, NULL, GETDATE(), GETDATE(), 'DNS   RYANK', 'DNS   RYANK');

--Correctional institution
INSERT INTO TBI.STD_TBIDISCHARGETO([CODE], [NAME], [DESCRIPTION_TEXT], [SORT_ORDER], [INACTIVE_FLAG], [INACTIVE_DATE], [CREATED], [UPDATED], 
[CREATEDBY], [UPDATEDBY]) VALUES('Correctional', 'Correctional Institution', 'Correctional Institution', 4, 0, NULL, GETDATE(), GETDATE(), 'DNS   RYANK', 'DNS   RYANK');

--Hotel
INSERT INTO TBI.STD_TBIDISCHARGETO([CODE], [NAME], [DESCRIPTION_TEXT], [SORT_ORDER], [INACTIVE_FLAG], [INACTIVE_DATE], [CREATED], [UPDATED], 
[CREATEDBY], [UPDATEDBY]) VALUES('Hotel', 'Hotel', 'Hotel', 5, 0, NULL, GETDATE(), GETDATE(), 'DNS   RYANK', 'DNS   RYANK');

--Homeless
INSERT INTO TBI.STD_TBIDISCHARGETO([CODE], [NAME], [DESCRIPTION_TEXT], [SORT_ORDER], [INACTIVE_FLAG], [INACTIVE_DATE], [CREATED], [UPDATED], 
[CREATEDBY], [UPDATEDBY]) VALUES('Homeless', 'Homeless', 'Homeless', 6, 0, NULL, GETDATE(), GETDATE(), 'DNS   RYANK', 'DNS   RYANK');

--Acute Hospital
INSERT INTO TBI.STD_TBIDISCHARGETO([CODE], [NAME], [DESCRIPTION_TEXT], [SORT_ORDER], [INACTIVE_FLAG], [INACTIVE_DATE], [CREATED], [UPDATED], 
[CREATEDBY], [UPDATEDBY]) VALUES('Acute_Hospital', 'Acute Hospital', 'Acute Hospital', 7, 0, NULL, GETDATE(), GETDATE(), 'DNS   RYANK', 'DNS   RYANK');

--Rehabilitation Hospital
INSERT INTO TBI.STD_TBIDISCHARGETO([CODE], [NAME], [DESCRIPTION_TEXT], [SORT_ORDER], [INACTIVE_FLAG], [INACTIVE_DATE], [CREATED], [UPDATED], 
[CREATEDBY], [UPDATEDBY]) VALUES('Rehab_Hospital', 'Rehabilitation Hospital', 'Rehabilitation Hospital', 8, 0, NULL, GETDATE(), GETDATE(), 'DNS   RYANK', 'DNS   RYANK');

--Other Hospital
INSERT INTO TBI.STD_TBIDISCHARGETO([CODE], [NAME], [DESCRIPTION_TEXT], [SORT_ORDER], [INACTIVE_FLAG], [INACTIVE_DATE], [CREATED], [UPDATED], 
[CREATEDBY], [UPDATEDBY]) VALUES('Other_Hospital', 'Other Hospital', 'Other Hospital', 9, 0, NULL, GETDATE(), GETDATE(), 'DNS   RYANK', 'DNS   RYANK');

--Sub-Acute Hospital
INSERT INTO TBI.STD_TBIDISCHARGETO([CODE], [NAME], [DESCRIPTION_TEXT], [SORT_ORDER], [INACTIVE_FLAG], [INACTIVE_DATE], [CREATED], [UPDATED], 
[CREATEDBY], [UPDATEDBY]) VALUES('SubAcute_Hospital', 'Sub-Acute Hospital', 'Sub-Acute Hospital', 10, 0, NULL, GETDATE(), GETDATE(), 'DNS   RYANK', 'DNS   RYANK');

--Military Housing (Apartment, Barracks or House)
INSERT INTO TBI.STD_TBIDISCHARGETO([CODE], [NAME], [DESCRIPTION_TEXT], [SORT_ORDER], [INACTIVE_FLAG], [INACTIVE_DATE], [CREATED], [UPDATED], 
[CREATEDBY], [UPDATEDBY]) VALUES('MTH', 'Military Housing', 'Apartment, Barracks or House', 11, 0, NULL, GETDATE(), GETDATE(), 'DNS   RYANK', 'DNS   RYANK');

-- Military Hospital (MTF)
INSERT INTO TBI.STD_TBIDISCHARGETO([CODE], [NAME], [DESCRIPTION_TEXT], [SORT_ORDER], [INACTIVE_FLAG], [INACTIVE_DATE], [CREATED], [UPDATED], 
[CREATEDBY], [UPDATEDBY]) VALUES('MTF', 'Military Hospital', 'Military Hospital', 12, 0, NULL, GETDATE(), GETDATE(), 'DNS   RYANK', 'DNS   RYANK');

--PTRP
INSERT INTO TBI.STD_TBIDISCHARGETO([CODE], [NAME], [DESCRIPTION_TEXT], [SORT_ORDER], [INACTIVE_FLAG], [INACTIVE_DATE], [CREATED], [UPDATED], 
[CREATEDBY], [UPDATEDBY]) VALUES('PTRP', 'Polytrauma Transitional Rehabilitation Program', 'Polytrauma Transitional Rehabilitation Program', 13, 0, NULL, GETDATE(), GETDATE(), 'DNS   RYANK', 'DNS   RYANK');

--Other 
INSERT INTO TBI.STD_TBIDISCHARGETO([CODE], [NAME], [DESCRIPTION_TEXT], [SORT_ORDER], [INACTIVE_FLAG], [INACTIVE_DATE], [CREATED], [UPDATED], 
[CREATEDBY], [UPDATEDBY]) VALUES('Other', 'Other', 'Other', 14, 0, NULL, GETDATE(), GETDATE(), 'DNS   RYANK', 'DNS   RYANK');

--Unknown
INSERT INTO TBI.STD_TBIDISCHARGETO([CODE], [NAME], [DESCRIPTION_TEXT], [SORT_ORDER], [INACTIVE_FLAG], [INACTIVE_DATE], [CREATED], [UPDATED], 
[CREATEDBY], [UPDATEDBY]) VALUES('Unknown', 'Unknown', 'Unknown', 15, 0, NULL, GETDATE(), GETDATE(), 'DNS   RYANK', 'DNS   RYANK');

END

/************ End Change #6 ************/


/************   Change #7   ************/
-- Create [TBI].[STD_POLYTRAUMA_SEVERITY_LEVEL_INDEX] table / Create column in POLYTRAUMA (SEVERITY_LEVEL_INDEX) FK
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[TBI].[STD_POLYTRAUMA_SEVERITY_LEVEL_INDEX]') AND type in (N'U'))
BEGIN
CREATE TABLE [TBI].[STD_POLYTRAUMA_SEVERITY_LEVEL_INDEX](
	[ID] [int] IDENTITY(1,1) NOT NULL,
	[CODE] [varchar](50) NOT NULL,
	[NAME] [varchar](100) NOT NULL,
	[DESCRIPTION_TEXT] [varchar](500) NOT NULL,
	[SORT_ORDER] [int] NOT NULL,
	[INACTIVE_FLAG] [bit] NOT NULL,
	[INACTIVE_DATE] [datetime] NULL,
	[CREATEDBY] [varchar](30) NOT NULL,
	[CREATED] [datetime] NOT NULL,
	[UPDATEDBY] [varchar](30) NOT NULL,
	[UPDATED] [datetime] NOT NULL,
	[ROW_VERSION] [timestamp] NOT NULL,
 CONSTRAINT [PK_STD_POLYTRAUMA_SEVERITY_LEVEL_INDEX] PRIMARY KEY CLUSTERED 
(
	[ID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]


-- INSERT INITIAL DATA

INSERT INTO [TBI].[STD_POLYTRAUMA_SEVERITY_LEVEL_INDEX]([CODE], [NAME], [DESCRIPTION_TEXT], [SORT_ORDER], [INACTIVE_FLAG], [INACTIVE_DATE], [CREATEDBY], 
[CREATED], [UPDATEDBY], [UPDATED]) 
VALUES('Mild', 'Mild', 'Mild', 1, 0, NULL, 'DNS   RYANK', GETDATE(), 'DNS   RYANK', GETDATE());

INSERT INTO [TBI].[STD_POLYTRAUMA_SEVERITY_LEVEL_INDEX]([CODE], [NAME], [DESCRIPTION_TEXT], [SORT_ORDER], [INACTIVE_FLAG], [INACTIVE_DATE], [CREATEDBY], 
[CREATED], [UPDATEDBY], [UPDATED]) 
VALUES('Moderate', 'Moderate', 'Moderate', 2, 0, NULL, 'DNS   RYANK', GETDATE(), 'DNS   RYANK', GETDATE());

INSERT INTO [TBI].[STD_POLYTRAUMA_SEVERITY_LEVEL_INDEX]([CODE], [NAME], [DESCRIPTION_TEXT], [SORT_ORDER], [INACTIVE_FLAG], [INACTIVE_DATE], [CREATEDBY], 
[CREATED], [UPDATEDBY], [UPDATED]) 
VALUES('Severe', 'Severe', 'Severe', 3, 0, NULL, 'DNS   RYANK', GETDATE(), 'DNS   RYANK', GETDATE());

INSERT INTO [TBI].[STD_POLYTRAUMA_SEVERITY_LEVEL_INDEX]([CODE], [NAME], [DESCRIPTION_TEXT], [SORT_ORDER], [INACTIVE_FLAG], [INACTIVE_DATE], [CREATEDBY], 
[CREATED], [UPDATEDBY], [UPDATED]) 
VALUES('NA', 'N/A', 'Not Applicable', 4, 0, NULL, 'DNS   RYANK', GETDATE(), 'DNS   RYANK', GETDATE());

END
GO

-- Add SEVERITY_LEVEL_INDEX field (int null) - FK to [TBI].[STD_POLYTRAUMA_SEVERITY_LEVEL_INDEX]
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'TBI_POLYTRAUMA' AND COLUMN_NAME = 'SEVERITY_LEVEL_INDEX_ID')
BEGIN

ALTER TABLE TBI.TBI_POLYTRAUMA ADD SEVERITY_LEVEL_INDEX_ID int NULL

ALTER TABLE TBI.TBI_POLYTRAUMA ADD CONSTRAINT
	FK_TBI_POLYTRAUMA_STD_POLYTRAUMA_SEVERITY_LEVEL_INDEX FOREIGN KEY
	(
	SEVERITY_LEVEL_INDEX_ID
	) REFERENCES TBI.STD_POLYTRAUMA_SEVERITY_LEVEL_INDEX
	(
	ID
	) ON UPDATE  NO ACTION 
	 ON DELETE  NO ACTION 
	
END
GO

/************ End Change #7 ************/


/************   Change #8   ************/
-- Add DAYS_FROM_ONSET field to POLYTRAUMA - stores calculated days from onset to admission
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'TBI_POLYTRAUMA' AND COLUMN_NAME = 'DAYS_FROM_ONSET')
ALTER TABLE TBI.TBI_POLYTRAUMA ADD DAYS_FROM_ONSET int NULL
GO

/************ End Change #8 ************/


/************   Change #9   ************/
-- Add PTRP_PROGRAM to POLYTRAUMA table (varchar(10) null)
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'TBI_POLYTRAUMA' AND COLUMN_NAME = 'PTRP_PROGRAM')
ALTER TABLE TBI.TBI_POLYTRAUMA ADD PTRP_PROGRAM varchar(10) NULL
GO

/************ End Change #9 ************/


/************   Change #10   ************/
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[TBI].[STD_PERSON_LIVING_WITH]') AND type in (N'U'))
BEGIN
CREATE TABLE [TBI].[STD_PERSON_LIVING_WITH](
	[ID] [int] IDENTITY(1,1) NOT NULL,
	[CODE] [varchar](50) NOT NULL,
	[NAME] [varchar](100) NOT NULL,
	[DESCRIPTION_TEXT] [varchar](500) NOT NULL,
	[SORT_ORDER] [int] NOT NULL,
	[INACTIVE_FLAG] [bit] NOT NULL,
	[INACTIVE_DATE] [datetime] NULL,
	[CREATEDBY] [varchar](30) NOT NULL,
	[CREATED] [datetime] NOT NULL,
	[UPDATEDBY] [varchar](30) NOT NULL,
	[UPDATED] [datetime] NOT NULL,
	[ROW_VERSION] [timestamp] NOT NULL,
 CONSTRAINT [PK_STD_PERSON_LIVING_WITH] PRIMARY KEY CLUSTERED 
(
	[ID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]


-- INSERT INITIAL DATA

-- Alone
INSERT INTO [TBI].[STD_PERSON_LIVING_WITH]([CODE], [NAME], [DESCRIPTION_TEXT], [SORT_ORDER], [INACTIVE_FLAG], [INACTIVE_DATE], [CREATEDBY], 
[CREATED], [UPDATEDBY], [UPDATED]) 
VALUES('Alone', 'Alone', 'Alone', 1, 0, NULL, 'DNS   RYANK', GETDATE(), 'DNS   RYANK', GETDATE());

-- Spouse
INSERT INTO [TBI].[STD_PERSON_LIVING_WITH]([CODE], [NAME], [DESCRIPTION_TEXT], [SORT_ORDER], [INACTIVE_FLAG], [INACTIVE_DATE], [CREATEDBY], 
[CREATED], [UPDATEDBY], [UPDATED]) 
VALUES('Spouse', 'Spouse', 'Spouse', 2, 0, NULL, 'DNS   RYANK', GETDATE(), 'DNS   RYANK', GETDATE());

-- Parent(s)
INSERT INTO [TBI].[STD_PERSON_LIVING_WITH]([CODE], [NAME], [DESCRIPTION_TEXT], [SORT_ORDER], [INACTIVE_FLAG], [INACTIVE_DATE], [CREATEDBY], 
[CREATED], [UPDATEDBY], [UPDATED]) 
VALUES('Parent', 'Parent(s)', 'Parent(s)', 3, 0, NULL, 'DNS   RYANK', GETDATE(), 'DNS   RYANK', GETDATE());

-- Sibling
INSERT INTO [TBI].[STD_PERSON_LIVING_WITH]([CODE], [NAME], [DESCRIPTION_TEXT], [SORT_ORDER], [INACTIVE_FLAG], [INACTIVE_DATE], [CREATEDBY], 
[CREATED], [UPDATEDBY], [UPDATED]) 
VALUES('Sibling', 'Sibling', 'Sibling', 4, 0, NULL, 'DNS   RYANK', GETDATE(), 'DNS   RYANK', GETDATE());

-- Child<21
INSERT INTO [TBI].[STD_PERSON_LIVING_WITH]([CODE], [NAME], [DESCRIPTION_TEXT], [SORT_ORDER], [INACTIVE_FLAG], [INACTIVE_DATE], [CREATEDBY], 
[CREATED], [UPDATEDBY], [UPDATED]) 
VALUES('YChild', 'Child < 21', 'Child < 21', 5, 0, NULL, 'DNS   RYANK', GETDATE(), 'DNS   RYANK', GETDATE());

-- Child>=21/Other Relative
INSERT INTO [TBI].[STD_PERSON_LIVING_WITH]([CODE], [NAME], [DESCRIPTION_TEXT], [SORT_ORDER], [INACTIVE_FLAG], [INACTIVE_DATE], [CREATEDBY], 
[CREATED], [UPDATEDBY], [UPDATED]) 
VALUES('AChildOther', 'Child >= 21 / Other Relative', 'Child >= 21 / Other Relative', 6, 0, NULL, 'DNS   RYANK', GETDATE(), 'DNS   RYANK', GETDATE());

-- Roommate/Friend 
INSERT INTO [TBI].[STD_PERSON_LIVING_WITH]([CODE], [NAME], [DESCRIPTION_TEXT], [SORT_ORDER], [INACTIVE_FLAG], [INACTIVE_DATE], [CREATEDBY], 
[CREATED], [UPDATEDBY], [UPDATED]) 
VALUES('Roommate', 'Roommate / Friend', 'Roommate / Friend', 7, 0, NULL, 'DNS   RYANK', GETDATE(), 'DNS   RYANK', GETDATE());

-- Significant Other 
INSERT INTO [TBI].[STD_PERSON_LIVING_WITH]([CODE], [NAME], [DESCRIPTION_TEXT], [SORT_ORDER], [INACTIVE_FLAG], [INACTIVE_DATE], [CREATEDBY], 
[CREATED], [UPDATEDBY], [UPDATED]) 
VALUES('SignificantOther', 'Significant Other', 'Significant Other', 8, 0, NULL, 'DNS   RYANK', GETDATE(), 'DNS   RYANK', GETDATE());

-- Other Patients 
INSERT INTO [TBI].[STD_PERSON_LIVING_WITH]([CODE], [NAME], [DESCRIPTION_TEXT], [SORT_ORDER], [INACTIVE_FLAG], [INACTIVE_DATE], [CREATEDBY], 
[CREATED], [UPDATEDBY], [UPDATED]) 
VALUES('OtherPatients', 'Other Patients', 'Other Patients', 9, 0, NULL, 'DNS   RYANK', GETDATE(), 'DNS   RYANK', GETDATE());

-- Other Residents
INSERT INTO [TBI].[STD_PERSON_LIVING_WITH]([CODE], [NAME], [DESCRIPTION_TEXT], [SORT_ORDER], [INACTIVE_FLAG], [INACTIVE_DATE], [CREATEDBY], 
[CREATED], [UPDATEDBY], [UPDATED]) 
VALUES('OtherResidents', 'Other Residents', 'Other Residents', 10, 0, NULL, 'DNS   RYANK', GETDATE(), 'DNS   RYANK', GETDATE());

-- Personal Care Attendant
INSERT INTO [TBI].[STD_PERSON_LIVING_WITH]([CODE], [NAME], [DESCRIPTION_TEXT], [SORT_ORDER], [INACTIVE_FLAG], [INACTIVE_DATE], [CREATEDBY], 
[CREATED], [UPDATEDBY], [UPDATED]) 
VALUES('PersonalCareAttendant', 'Personal Care Attendant', 'Personal Care Attendant', 11, 0, NULL, 'DNS   RYANK', GETDATE(), 'DNS   RYANK', GETDATE());

-- Other 
INSERT INTO [TBI].[STD_PERSON_LIVING_WITH]([CODE], [NAME], [DESCRIPTION_TEXT], [SORT_ORDER], [INACTIVE_FLAG], [INACTIVE_DATE], [CREATEDBY], 
[CREATED], [UPDATEDBY], [UPDATED]) 
VALUES('Other', 'Other', 'Other', 12, 0, NULL, 'DNS   RYANK', GETDATE(), 'DNS   RYANK', GETDATE());

-- Other Military Personnel 
INSERT INTO [TBI].[STD_PERSON_LIVING_WITH]([CODE], [NAME], [DESCRIPTION_TEXT], [SORT_ORDER], [INACTIVE_FLAG], [INACTIVE_DATE], [CREATEDBY], 
[CREATED], [UPDATEDBY], [UPDATED]) 
VALUES('OtherMilitary', 'Other Military Personnel', 'Other Military Personnel', 13, 0, NULL, 'DNS   RYANK', GETDATE(), 'DNS   RYANK', GETDATE());

-- Unknown 
INSERT INTO [TBI].[STD_PERSON_LIVING_WITH]([CODE], [NAME], [DESCRIPTION_TEXT], [SORT_ORDER], [INACTIVE_FLAG], [INACTIVE_DATE], [CREATEDBY], 
[CREATED], [UPDATEDBY], [UPDATED]) 
VALUES('Unknown', 'Unknown', 'Unknown', 14, 0, NULL, 'DNS   RYANK', GETDATE(), 'DNS   RYANK', GETDATE());


END
GO

-- Add PREINJURY_PRIM_PERSON_LIVING_WITH_ID field (int null) - FK to [TBI].[STD_PERSON_LIVING_WITH]
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'TBI_POLYTRAUMA' AND COLUMN_NAME = 'PREINJURY_PRIM_PERSON_LIVING_WITH_ID')
BEGIN

ALTER TABLE TBI.TBI_POLYTRAUMA ADD PREINJURY_PRIM_PERSON_LIVING_WITH_ID int NULL

ALTER TABLE TBI.TBI_POLYTRAUMA ADD CONSTRAINT
	FK_TBI_POLYTRAUMA_PREINJURY_PRIM_STD_PERSON_LIVING_WITH FOREIGN KEY
	(
	PREINJURY_PRIM_PERSON_LIVING_WITH_ID
	) REFERENCES TBI.STD_PERSON_LIVING_WITH
	(
	ID
	) ON UPDATE  NO ACTION 
	 ON DELETE  NO ACTION 
	
END
GO

/************ End Change #10  ************/


/************ Change #11  ************/

-- Add PREINJURY_RESIDENCE_ID field (int null) - FK to [TBI].[STD_TBIDISCHARGETO]
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'TBI_POLYTRAUMA' AND COLUMN_NAME = 'PREINJURY_RESIDENCE_ID')
BEGIN

ALTER TABLE TBI.TBI_POLYTRAUMA ADD PREINJURY_RESIDENCE_ID int NULL

ALTER TABLE TBI.TBI_POLYTRAUMA ADD CONSTRAINT
	FK_TBI_POLYTRAUMA_PREINJURY_RESIDENCE_ID_STD_TBIDISCHARGETO FOREIGN KEY
	(
	PREINJURY_RESIDENCE_ID
	) REFERENCES TBI.STD_TBIDISCHARGETO
	(
	ID
	) ON UPDATE  NO ACTION 
	 ON DELETE  NO ACTION 
	
END
GO

/************ End Change #11  ************/


/************ Change #12  ************/
-- Create STD_POLYTRAUMA_EMPLOYMENT_STATUS table and populate with initial data.
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[TBI].[STD_POLYTRAUMA_EMPLOYMENT_STATUS]') AND type in (N'U'))
BEGIN
CREATE TABLE [TBI].[STD_POLYTRAUMA_EMPLOYMENT_STATUS](
	[ID] [int] IDENTITY(1,1) NOT NULL,
	[CODE] [varchar](50) NOT NULL,
	[NAME] [varchar](100) NOT NULL,
	[DESCRIPTION_TEXT] [varchar](500) NOT NULL,
	[SORT_ORDER] [int] NOT NULL,
	[INACTIVE_FLAG] [bit] NOT NULL,
	[INACTIVE_DATE] [datetime] NULL,
	[CREATEDBY] [varchar](30) NOT NULL,
	[CREATED] [datetime] NOT NULL,
	[UPDATEDBY] [varchar](30) NOT NULL,
	[UPDATED] [datetime] NOT NULL,
	[ROW_VERSION] [timestamp] NOT NULL,
 CONSTRAINT [PK_STD_POLYTRAUMA_EMPLOYMENT_STATUS] PRIMARY KEY CLUSTERED 
(
	[ID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]

-- INSERT INITIAL DATA
-- Full-time student (regular class)
INSERT INTO [TBI].[STD_POLYTRAUMA_EMPLOYMENT_STATUS]([CODE], [NAME], [DESCRIPTION_TEXT], [SORT_ORDER], [INACTIVE_FLAG], [INACTIVE_DATE], [CREATEDBY], 
[CREATED], [UPDATEDBY], [UPDATED]) 
VALUES('FT_STUDENT', 'Full-time student (regular class)', 'Full-time student (regular class)', 1, 0, NULL, 'DNS   RYANK', GETDATE(), 'DNS   RYANK', GETDATE());

-- Part-time student (regular class)
INSERT INTO [TBI].[STD_POLYTRAUMA_EMPLOYMENT_STATUS]([CODE], [NAME], [DESCRIPTION_TEXT], [SORT_ORDER], [INACTIVE_FLAG], [INACTIVE_DATE], [CREATEDBY], 
[CREATED], [UPDATEDBY], [UPDATED]) 
VALUES('PT_STUDENT', 'Part-time student (regular class)', 'Part-time student (regular class)', 2, 0, NULL, 'DNS   RYANK', GETDATE(), 'DNS   RYANK', GETDATE());

-- Special education/other non-regular education
INSERT INTO [TBI].[STD_POLYTRAUMA_EMPLOYMENT_STATUS]([CODE], [NAME], [DESCRIPTION_TEXT], [SORT_ORDER], [INACTIVE_FLAG], [INACTIVE_DATE], [CREATEDBY], 
[CREATED], [UPDATEDBY], [UPDATED]) 
VALUES('SPEC_ED', 'Special education/other non-regular education', 'Special education/other non-regular education', 3, 0, NULL, 'DNS   RYANK', GETDATE(), 'DNS   RYANK', GETDATE());

-- Competitively employed
INSERT INTO [TBI].[STD_POLYTRAUMA_EMPLOYMENT_STATUS]([CODE], [NAME], [DESCRIPTION_TEXT], [SORT_ORDER], [INACTIVE_FLAG], [INACTIVE_DATE], [CREATEDBY], 
[CREATED], [UPDATEDBY], [UPDATED]) 
VALUES('COMP_EMPLOYED', 'Competitively employed', 'Competitively employed', 4, 0, NULL, 'DNS   RYANK', GETDATE(), 'DNS   RYANK', GETDATE());

-- Taking care of house or family
INSERT INTO [TBI].[STD_POLYTRAUMA_EMPLOYMENT_STATUS]([CODE], [NAME], [DESCRIPTION_TEXT], [SORT_ORDER], [INACTIVE_FLAG], [INACTIVE_DATE], [CREATEDBY], 
[CREATED], [UPDATEDBY], [UPDATED]) 
VALUES('HOME', 'Taking care of house or family', 'Taking care of house or family', 5, 0, NULL, 'DNS   RYANK', GETDATE(), 'DNS   RYANK', GETDATE());

-- Special employed (sheltered workshop, supportive employment, job coach) 
INSERT INTO [TBI].[STD_POLYTRAUMA_EMPLOYMENT_STATUS]([CODE], [NAME], [DESCRIPTION_TEXT], [SORT_ORDER], [INACTIVE_FLAG], [INACTIVE_DATE], [CREATEDBY], 
[CREATED], [UPDATEDBY], [UPDATED]) 
VALUES('SPEC_EMPLOYED', 'Special employed', 'Special employed (sheltered workshop, supportive employment, job coach) ', 6, 0, NULL, 'DNS   RYANK', GETDATE(), 'DNS   RYANK', GETDATE());

-- Retired (age)
INSERT INTO [TBI].[STD_POLYTRAUMA_EMPLOYMENT_STATUS]([CODE], [NAME], [DESCRIPTION_TEXT], [SORT_ORDER], [INACTIVE_FLAG], [INACTIVE_DATE], [CREATEDBY], 
[CREATED], [UPDATEDBY], [UPDATED]) 
VALUES('RETIRED_AGE', 'Retired (age)', 'Retired (age)', 7, 0, NULL, 'DNS   RYANK', GETDATE(), 'DNS   RYANK', GETDATE());

-- Unemployed (looking for work in the last 4 weeks)
INSERT INTO [TBI].[STD_POLYTRAUMA_EMPLOYMENT_STATUS]([CODE], [NAME], [DESCRIPTION_TEXT], [SORT_ORDER], [INACTIVE_FLAG], [INACTIVE_DATE], [CREATEDBY], 
[CREATED], [UPDATEDBY], [UPDATED]) 
VALUES('UNEMPLOYED_SEEK', 'Unemployed (seeking)', 'Unemployed (looking for work in the last 4 weeks)', 8, 0, NULL, 'DNS   RYANK', GETDATE(), 'DNS   RYANK', GETDATE());

-- Volunteer work
INSERT INTO [TBI].[STD_POLYTRAUMA_EMPLOYMENT_STATUS]([CODE], [NAME], [DESCRIPTION_TEXT], [SORT_ORDER], [INACTIVE_FLAG], [INACTIVE_DATE], [CREATEDBY], 
[CREATED], [UPDATEDBY], [UPDATED]) 
VALUES('VOLUNTEER', 'Volunteer work', 'Volunteer work', 9, 0, NULL, 'DNS   RYANK', GETDATE(), 'DNS   RYANK', GETDATE());

-- Retired (disability)
INSERT INTO [TBI].[STD_POLYTRAUMA_EMPLOYMENT_STATUS]([CODE], [NAME], [DESCRIPTION_TEXT], [SORT_ORDER], [INACTIVE_FLAG], [INACTIVE_DATE], [CREATEDBY], 
[CREATED], [UPDATEDBY], [UPDATED]) 
VALUES('RETIRED_DISABILITY', 'Retired (disability)', 'Retired (disability)', 10, 0, NULL, 'DNS   RYANK', GETDATE(), 'DNS   RYANK', GETDATE());

-- Unemployed (not looking for work in the last 4 weeks for any reason)
INSERT INTO [TBI].[STD_POLYTRAUMA_EMPLOYMENT_STATUS]([CODE], [NAME], [DESCRIPTION_TEXT], [SORT_ORDER], [INACTIVE_FLAG], [INACTIVE_DATE], [CREATEDBY], 
[CREATED], [UPDATEDBY], [UPDATED]) 
VALUES('UNEMPLOYED_NOT_SEEK', 'Unemployed (not seeking)', 'Unemployed (not looking for work in the last 4 weeks for any reason)', 11, 0, NULL, 'DNS   RYANK', GETDATE(), 'DNS   RYANK', GETDATE());

-- Hospitalized without pay for last 4 weeks
INSERT INTO [TBI].[STD_POLYTRAUMA_EMPLOYMENT_STATUS]([CODE], [NAME], [DESCRIPTION_TEXT], [SORT_ORDER], [INACTIVE_FLAG], [INACTIVE_DATE], [CREATEDBY], 
[CREATED], [UPDATEDBY], [UPDATED]) 
VALUES('HOSPITAL_NO_PAY', 'Hospitalized without pay for last 4 weeks', 'Hospitalized without pay for last 4 weeks', 12, 0, NULL, 'DNS   RYANK', GETDATE(), 'DNS   RYANK', GETDATE());

-- Retired (other)
INSERT INTO [TBI].[STD_POLYTRAUMA_EMPLOYMENT_STATUS]([CODE], [NAME], [DESCRIPTION_TEXT], [SORT_ORDER], [INACTIVE_FLAG], [INACTIVE_DATE], [CREATEDBY], 
[CREATED], [UPDATEDBY], [UPDATED]) 
VALUES('RETIRED_OTHER', 'Retired (other)', 'Retired (other)', 13, 0, NULL, 'DNS   RYANK', GETDATE(), 'DNS   RYANK', GETDATE());

-- On leave from work, not receiving pay
INSERT INTO [TBI].[STD_POLYTRAUMA_EMPLOYMENT_STATUS]([CODE], [NAME], [DESCRIPTION_TEXT], [SORT_ORDER], [INACTIVE_FLAG], [INACTIVE_DATE], [CREATEDBY], 
[CREATED], [UPDATEDBY], [UPDATED]) 
VALUES('LEAVE_NO_PAY', 'On leave from work, not receiving pay', 'On leave from work, not receiving pay', 14, 0, NULL, 'DNS   RYANK', GETDATE(), 'DNS   RYANK', GETDATE());

-- Other
INSERT INTO [TBI].[STD_POLYTRAUMA_EMPLOYMENT_STATUS]([CODE], [NAME], [DESCRIPTION_TEXT], [SORT_ORDER], [INACTIVE_FLAG], [INACTIVE_DATE], [CREATEDBY], 
[CREATED], [UPDATEDBY], [UPDATED]) 
VALUES('OTHER', 'Other', 'Other', 15, 0, NULL, 'DNS   RYANK', GETDATE(), 'DNS   RYANK', GETDATE());

-- Warrior Transition Unit/Brigade
INSERT INTO [TBI].[STD_POLYTRAUMA_EMPLOYMENT_STATUS]([CODE], [NAME], [DESCRIPTION_TEXT], [SORT_ORDER], [INACTIVE_FLAG], [INACTIVE_DATE], [CREATEDBY], 
[CREATED], [UPDATEDBY], [UPDATED]) 
VALUES('WTU_BRIGADE', 'Warrior Transition Unit/Brigade', 'Warrior Transition Unit/Brigade', 16, 0, NULL, 'DNS   RYANK', GETDATE(), 'DNS   RYANK', GETDATE());

-- Refused
INSERT INTO [TBI].[STD_POLYTRAUMA_EMPLOYMENT_STATUS]([CODE], [NAME], [DESCRIPTION_TEXT], [SORT_ORDER], [INACTIVE_FLAG], [INACTIVE_DATE], [CREATEDBY], 
[CREATED], [UPDATEDBY], [UPDATED]) 
VALUES('REFUSED', 'Refused', 'Refused', 17, 0, NULL, 'DNS   RYANK', GETDATE(), 'DNS   RYANK', GETDATE());

-- UNKNOWN
INSERT INTO [TBI].[STD_POLYTRAUMA_EMPLOYMENT_STATUS]([CODE], [NAME], [DESCRIPTION_TEXT], [SORT_ORDER], [INACTIVE_FLAG], [INACTIVE_DATE], [CREATEDBY], 
[CREATED], [UPDATEDBY], [UPDATED]) 
VALUES('UNKNOWN', 'Unknown', 'Unknown', 18, 0, NULL, 'DNS   RYANK', GETDATE(), 'DNS   RYANK', GETDATE());

END
GO

-- Add PREINJURY_PRIM_PERSON_LIVING_WITH_ID field (int null) - FK to [TBI].[STD_POLYTRAUMA_EMPLOYMENT_STATUS]
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'TBI_POLYTRAUMA' AND COLUMN_NAME = 'PRI_PREINJURY_EMPLOY_STATUS_ID')
BEGIN

-- add fields
ALTER TABLE TBI.TBI_POLYTRAUMA ADD PRI_PREINJURY_EMPLOY_STATUS_ID int NULL

ALTER TABLE TBI.TBI_POLYTRAUMA ADD SEC_PREINJURY_EMPLOY_STATUS_ID int NULL

-- add constraints to STD_POLYTRAUMA_EMPLOYMENT_STATUS
ALTER TABLE TBI.TBI_POLYTRAUMA ADD CONSTRAINT
	FK_TBI_POLYTRAUMA_PRI_STD_POLYTRAUMA_EMPLOYMENT_STATUS FOREIGN KEY
	(
	PRI_PREINJURY_EMPLOY_STATUS_ID
	) REFERENCES TBI.STD_POLYTRAUMA_EMPLOYMENT_STATUS
	(
	ID
	) ON UPDATE  NO ACTION 
	 ON DELETE  NO ACTION 


ALTER TABLE TBI.TBI_POLYTRAUMA ADD CONSTRAINT
	FK_TBI_POLYTRAUMA_SEC_STD_POLYTRAUMA_EMPLOYMENT_STATUS FOREIGN KEY
	(
	SEC_PREINJURY_EMPLOY_STATUS_ID
	) REFERENCES TBI.STD_POLYTRAUMA_EMPLOYMENT_STATUS
	(
	ID
	) ON UPDATE  NO ACTION 
	 ON DELETE  NO ACTION 
	
END
GO

/************ End Change #12  ************/


/************ Change #13  ************/
-- Add MPAI score columns to POLYTRAUMA table

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'TBI_POLYTRAUMA' AND COLUMN_NAME = 'MPAI_ABILITIES_INITIAL')
ALTER TABLE TBI.TBI_POLYTRAUMA ADD MPAI_ABILITIES_INITIAL int NULL

/*** -- Removed by stakeholder
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'TBI_POLYTRAUMA' AND COLUMN_NAME = 'MPAI_ABILITIES_DC')
ALTER TABLE TBI.TBI_POLYTRAUMA ADD MPAI_ABILITIES_DC int NULL
**/

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'TBI_POLYTRAUMA' AND COLUMN_NAME = 'MPAI_ABILITIES_FOLLOWUP')
ALTER TABLE TBI.TBI_POLYTRAUMA ADD MPAI_ABILITIES_FOLLOWUP int NULL

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'TBI_POLYTRAUMA' AND COLUMN_NAME = 'MPAI_ADJUSTMENT_INITIAL')
ALTER TABLE TBI.TBI_POLYTRAUMA ADD MPAI_ADJUSTMENT_INITIAL int NULL

/*** -- Removed by stakeholder
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'TBI_POLYTRAUMA' AND COLUMN_NAME = 'MPAI_ADJUSTMENT_DC')
ALTER TABLE TBI.TBI_POLYTRAUMA ADD MPAI_ADJUSTMENT_DC int NULL
**/

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'TBI_POLYTRAUMA' AND COLUMN_NAME = 'MPAI_ADJUSTMENT_FOLLOWUP')
ALTER TABLE TBI.TBI_POLYTRAUMA ADD MPAI_ADJUSTMENT_FOLLOWUP int NULL

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'TBI_POLYTRAUMA' AND COLUMN_NAME = 'MPAI_PARTICIPATION_INITIAL')
ALTER TABLE TBI.TBI_POLYTRAUMA ADD MPAI_PARTICIPATION_INITIAL int NULL

/*** -- Removed by stakeholder
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'TBI_POLYTRAUMA' AND COLUMN_NAME = 'MPAI_PARTICIPATION_DC')
ALTER TABLE TBI.TBI_POLYTRAUMA ADD MPAI_PARTICIPATION_DC int NULL
**/

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'TBI_POLYTRAUMA' AND COLUMN_NAME = 'MPAI_PARTICIPATION_FOLLOWUP')
ALTER TABLE TBI.TBI_POLYTRAUMA ADD MPAI_PARTICIPATION_FOLLOWUP int NULL

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'TBI_POLYTRAUMA' AND COLUMN_NAME = 'MPAI_TOTAL_INITIAL')
ALTER TABLE TBI.TBI_POLYTRAUMA ADD MPAI_TOTAL_INITIAL int NULL

/*** -- Removed by stakeholder
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'TBI_POLYTRAUMA' AND COLUMN_NAME = 'MPAI_TOTAL_DC')
ALTER TABLE TBI.TBI_POLYTRAUMA ADD MPAI_TOTAL_DC int NULL
**/

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'TBI_POLYTRAUMA' AND COLUMN_NAME = 'MPAI_TOTAL_FOLLOWUP')
ALTER TABLE TBI.TBI_POLYTRAUMA ADD MPAI_TOTAL_FOLLOWUP int NULL

GO

/************ End Change #13  ************/


/************ Change #14  ************/
-- Create (3) columns for storing MPAI Q26 values for admission, discharge, and followup

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'TBI_POLYTRAUMA' AND COLUMN_NAME = 'MPAI_Q26_ADMISSION')
ALTER TABLE TBI.TBI_POLYTRAUMA ADD MPAI_Q26_ADMISSION int NULL

/*** -- Removed by stakeholder
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'TBI_POLYTRAUMA' AND COLUMN_NAME = 'MPAI_Q26_DC')
ALTER TABLE TBI.TBI_POLYTRAUMA ADD MPAI_Q26_DC int NULL
**/

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'TBI_POLYTRAUMA' AND COLUMN_NAME = 'MPAI_Q26_FOLLOWUP')
ALTER TABLE TBI.TBI_POLYTRAUMA ADD MPAI_Q26_FOLLOWUP int NULL

GO

/************ End Change #14  ************/


/************ Change #15  ************/
-- Create (3) new fields (int null) for storing Satisfaction with Life Score (score range from 5 to 35) for admission, discharge, and followup
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'TBI_POLYTRAUMA' AND COLUMN_NAME = 'SATIS_W_LIFE_ADMISSION')
ALTER TABLE TBI.TBI_POLYTRAUMA ADD SATIS_W_LIFE_ADMISSION int NULL

/*** -- Removed by stakeholder
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'TBI_POLYTRAUMA' AND COLUMN_NAME = 'SATIS_W_LIFE_DC')
ALTER TABLE TBI.TBI_POLYTRAUMA ADD SATIS_W_LIFE_DC int NULL
**/

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'TBI_POLYTRAUMA' AND COLUMN_NAME = 'SATIS_W_LIFE_FOLLOWUP')
ALTER TABLE TBI.TBI_POLYTRAUMA ADD SATIS_W_LIFE_FOLLOWUP int NULL

GO

/************ End Change #15  ************/


/************ Change #16  ************/
-- Create new fields PART_FOLLOWUP (int null) for storing PART (0  128 range) - Participation Assessment with Recombined Tools (PART) for followup
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'TBI_POLYTRAUMA' AND COLUMN_NAME = 'PART_FOLLOWUP')
ALTER TABLE TBI.TBI_POLYTRAUMA ADD PART_FOLLOWUP int NULL

/************ End Change #16  ************/


/************ Change #17  ************/
-- Create (3) new fields (int null) for WHO_QOL_ADMISSION, WHO_QOL_DC, and WHO_QOL_FOLLOWUP
/**
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'TBI_POLYTRAUMA' AND COLUMN_NAME = 'WHO_QOL_ADMISSION')
ALTER TABLE TBI.TBI_POLYTRAUMA ADD WHO_QOL_ADMISSION int NULL
**/
/*** -- Removed by stakeholder
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'TBI_POLYTRAUMA' AND COLUMN_NAME = 'WHO_QOL_DC')
ALTER TABLE TBI.TBI_POLYTRAUMA ADD WHO_QOL_DC int NULL
**/
/**
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'TBI_POLYTRAUMA' AND COLUMN_NAME = 'WHO_QOL_FOLLOWUP')
ALTER TABLE TBI.TBI_POLYTRAUMA ADD WHO_QOL_FOLLOWUP int NULL
**/
/************ End Change #17  ************/


/************ Change #18  ************/

IF (SELECT MAX(ID) FROM TBI.STD_TBIDSCHRGSTS) < 6
BEGIN

UPDATE TBI.STD_TBIDSCHRGSTS SET [INACTIVE_FLAG] = 1, [INACTIVE_DATE] = GETDATE() WHERE ID < 6;

-- Active Duty
INSERT INTO TBI.STD_TBIDSCHRGSTS([CODE], [NAME], [DESCRIPTION_TEXT], [SORT_ORDER], [INACTIVE_FLAG], [INACTIVE_DATE], [CREATED], [UPDATED], 
[CREATEDBY], [UPDATEDBY]) VALUES('ACTIVE_DUTY', 'Active Duty', 'Active Duty', 1, 0, NULL, GETDATE(), GETDATE(), 'DNS   RYANK', 'DNS   RYANK');

-- Temporary Disability Retired List (TDRL)
INSERT INTO TBI.STD_TBIDSCHRGSTS([CODE], [NAME], [DESCRIPTION_TEXT], [SORT_ORDER], [INACTIVE_FLAG], [INACTIVE_DATE], [CREATED], [UPDATED], 
[CREATEDBY], [UPDATEDBY]) VALUES('TDRL', 'Temporary Disability Retired List', 'Temporary Disability Retired List (TDRL)', 2, 0, NULL, GETDATE(), GETDATE(), 'DNS   RYANK', 'DNS   RYANK');

-- Medical Evaluation Board in Process
INSERT INTO TBI.STD_TBIDSCHRGSTS([CODE], [NAME], [DESCRIPTION_TEXT], [SORT_ORDER], [INACTIVE_FLAG], [INACTIVE_DATE], [CREATED], [UPDATED], 
[CREATEDBY], [UPDATEDBY]) VALUES('MEB', 'Medical Evaluation Board in Process', 'Medical Evaluation Board in Process', 3, 0, NULL, GETDATE(), GETDATE(), 'DNS   RYANK', 'DNS   RYANK');

-- Convalescent Leave
INSERT INTO TBI.STD_TBIDSCHRGSTS([CODE], [NAME], [DESCRIPTION_TEXT], [SORT_ORDER], [INACTIVE_FLAG], [INACTIVE_DATE], [CREATED], [UPDATED], 
[CREATEDBY], [UPDATEDBY]) VALUES('CONVALESCENT_LEAVE', 'Convalescent Leave', 'Convalescent Leave', 4, 0, NULL, GETDATE(), GETDATE(), 'DNS   RYANK', 'DNS   RYANK');

-- Veteran
INSERT INTO TBI.STD_TBIDSCHRGSTS([CODE], [NAME], [DESCRIPTION_TEXT], [SORT_ORDER], [INACTIVE_FLAG], [INACTIVE_DATE], [CREATED], [UPDATED], 
[CREATEDBY], [UPDATEDBY]) VALUES('VETERAN', 'Veteran', 'Veteran', 5, 0, NULL, GETDATE(), GETDATE(), 'DNS   RYANK', 'DNS   RYANK');

END
GO

-- create new column for military duty status at discharge, and constraint for STD_TBIDSCHRGSTS
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'TBI_POLYTRAUMA' AND COLUMN_NAME = 'DC_MILITARY_DUTY_STATUS_ID')
BEGIN

ALTER TABLE TBI.TBI_POLYTRAUMA ADD DC_MILITARY_DUTY_STATUS_ID int NULL

ALTER TABLE TBI.TBI_POLYTRAUMA ADD CONSTRAINT
	FK_TBI_POLYTRAUMA_MILITARY_DUTY_STATUS_STD_TBIDSCHRGSTS FOREIGN KEY
	(
	DC_MILITARY_DUTY_STATUS_ID
	) REFERENCES TBI.STD_TBIDSCHRGSTS
	(
	ID
	) ON UPDATE  NO ACTION 
	 ON DELETE  NO ACTION 

END
GO

/************ End Change #18  ************/


/************ End Change #19  ************/
-- Add PRI_PERSON_LIVING_DC_ID field (int null) - FK to [TBI].[STD_PERSON_LIVING_WITH]
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'TBI_POLYTRAUMA' AND COLUMN_NAME = 'PRI_PERSON_LIVING_DC_ID')
BEGIN

ALTER TABLE TBI.TBI_POLYTRAUMA ADD PRI_PERSON_LIVING_DC_ID int NULL

ALTER TABLE TBI.TBI_POLYTRAUMA ADD CONSTRAINT
	FK_TBI_POLYTRAUMA_PRI_PERSON_DC_STD_PERSON_LIVING_WITH FOREIGN KEY
	(
	PRI_PERSON_LIVING_DC_ID
	) REFERENCES TBI.STD_PERSON_LIVING_WITH
	(
	ID
	) ON UPDATE  NO ACTION 
	 ON DELETE  NO ACTION 
	
END
GO

-- Add PRI_PERSON_LIVING_FOLLOWUP_ID field (int null) - FK to [TBI].[STD_PERSON_LIVING_WITH]
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'TBI_POLYTRAUMA' AND COLUMN_NAME = 'PRI_PERSON_LIVING_FOLLOWUP_ID')
BEGIN

ALTER TABLE TBI.TBI_POLYTRAUMA ADD PRI_PERSON_LIVING_FOLLOWUP_ID int NULL

ALTER TABLE TBI.TBI_POLYTRAUMA ADD CONSTRAINT
	FK_TBI_POLYTRAUMA_PRI_PERSON_FOLLOWUP_STD_PERSON_LIVING_WITH FOREIGN KEY
	(
	PRI_PERSON_LIVING_FOLLOWUP_ID
	) REFERENCES TBI.STD_PERSON_LIVING_WITH
	(
	ID
	) ON UPDATE  NO ACTION 
	 ON DELETE  NO ACTION 
	
END
GO

/************ End Change #19  ************/


/************ Change #20  ************/
-- Add DC_RESIDENCE_ID field (int null) - FK to [TBI].[STD_TBIDISCHARGETO]
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'TBI_POLYTRAUMA' AND COLUMN_NAME = 'DC_RESIDENCE_ID')
BEGIN

ALTER TABLE TBI.TBI_POLYTRAUMA ADD DC_RESIDENCE_ID int NULL

ALTER TABLE TBI.TBI_POLYTRAUMA ADD CONSTRAINT
	FK_TBI_POLYTRAUMA_DC_RESIDENCE_ID_STD_TBIDISCHARGETO FOREIGN KEY
	(
	DC_RESIDENCE_ID
	) REFERENCES TBI.STD_TBIDISCHARGETO
	(
	ID
	) ON UPDATE  NO ACTION 
	 ON DELETE  NO ACTION 
	
END
GO

-- Add FOLLOWUP_RESIDENCE_ID field (int null) - FK to [TBI].[STD_TBIDISCHARGETO]
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'TBI_POLYTRAUMA' AND COLUMN_NAME = 'FOLLOWUP_RESIDENCE_ID')
BEGIN

ALTER TABLE TBI.TBI_POLYTRAUMA ADD FOLLOWUP_RESIDENCE_ID int NULL

ALTER TABLE TBI.TBI_POLYTRAUMA ADD CONSTRAINT
	FK_TBI_POLYTRAUMA_FOLLOWUP_RESIDENCE_ID_STD_TBIDISCHARGETO FOREIGN KEY
	(
	FOLLOWUP_RESIDENCE_ID
	) REFERENCES TBI.STD_TBIDISCHARGETO
	(
	ID
	) ON UPDATE  NO ACTION 
	 ON DELETE  NO ACTION 
	
END
GO

/************ End Change #20  ************/


/************ End Change #21  ************/
-- Add PRI_DC_EMPLOY_STATUS_ID field (int null) - FK to [TBI].[STD_POLYTRAUMA_EMPLOYMENT_STATUS]
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'TBI_POLYTRAUMA' AND COLUMN_NAME = 'PRI_DC_EMPLOY_STATUS_ID')
BEGIN

-- add fields
ALTER TABLE TBI.TBI_POLYTRAUMA ADD PRI_DC_EMPLOY_STATUS_ID int NULL
ALTER TABLE TBI.TBI_POLYTRAUMA ADD SEC_DC_EMPLOY_STATUS_ID int NULL
ALTER TABLE TBI.TBI_POLYTRAUMA ADD PRI_FOLLOWUP_EMPLOY_STATUS_ID int NULL
ALTER TABLE TBI.TBI_POLYTRAUMA ADD SEC_FOLLOWUP_EMPLOY_STATUS_ID int NULL

-- add constraints to STD_POLYTRAUMA_EMPLOYMENT_STATUS
ALTER TABLE TBI.TBI_POLYTRAUMA ADD CONSTRAINT
	FK_TBI_POLYTRAUMA_PRI_DC_STD_POLYTRAUMA_EMPLOYMENT_STATUS FOREIGN KEY
	(
	PRI_DC_EMPLOY_STATUS_ID
	) REFERENCES TBI.STD_POLYTRAUMA_EMPLOYMENT_STATUS
	(
	ID
	) ON UPDATE  NO ACTION 
	 ON DELETE  NO ACTION 


ALTER TABLE TBI.TBI_POLYTRAUMA ADD CONSTRAINT
	FK_TBI_POLYTRAUMA_SEC_DC_STD_POLYTRAUMA_EMPLOYMENT_STATUS FOREIGN KEY
	(
	SEC_DC_EMPLOY_STATUS_ID
	) REFERENCES TBI.STD_POLYTRAUMA_EMPLOYMENT_STATUS
	(
	ID
	) ON UPDATE  NO ACTION 
	 ON DELETE  NO ACTION 
	 
ALTER TABLE TBI.TBI_POLYTRAUMA ADD CONSTRAINT
	FK_TBI_POLYTRAUMA_PRI_FOLLOWUP_STD_POLYTRAUMA_EMPLOYMENT_STATUS FOREIGN KEY
	(
	PRI_FOLLOWUP_EMPLOY_STATUS_ID
	) REFERENCES TBI.STD_POLYTRAUMA_EMPLOYMENT_STATUS
	(
	ID
	) ON UPDATE  NO ACTION 
	 ON DELETE  NO ACTION 


ALTER TABLE TBI.TBI_POLYTRAUMA ADD CONSTRAINT
	FK_TBI_POLYTRAUMA_SEC_FOLLOWUP_STD_POLYTRAUMA_EMPLOYMENT_STATUS FOREIGN KEY
	(
	SEC_FOLLOWUP_EMPLOY_STATUS_ID
	) REFERENCES TBI.STD_POLYTRAUMA_EMPLOYMENT_STATUS
	(
	ID
	) ON UPDATE  NO ACTION 
	 ON DELETE  NO ACTION 
	
END
GO

/************ End Change #21  ************/


/************ End Change #22  ************/
-- Set Walter Reed and National Naval to inactive and add WRNNMC
IF (SELECT MAX(ID) FROM TBI.STD_TBIFACILITYSRC) < 7
BEGIN

UPDATE TBI.STD_TBIFACILITYSRC SET [INACTIVE_FLAG] = 1, [INACTIVE_DATE] = GETDATE() WHERE ID < 3;

INSERT INTO TBI.STD_TBIFACILITYSRC([CODE], [NAME], [DESCRIPTION_TEXT], [SORT_ORDER], [INACTIVE_FLAG], [INACTIVE_DATE], [CREATED], [UPDATED], 
[CREATEDBY], [UPDATEDBY]) VALUES('WRNNMC', 'WRNNMC', 'WRNNMC', 1, 0, NULL, GETDATE(), GETDATE(), 'DNS   RYANK', 'DNS   RYANK');

END

/************ End Change #22  ************/